/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.rei.modifiers;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import slimeknights.tconstruct.library.recipe.worktable.IModifierWorktableRecipe;
import slimeknights.tconstruct.plugin.rei.TConstructREIConstants;

public class ModifierWorktableDisplay
implements Display {
    private final List<EntryIngredient> inputEntries;
    private final List<EntryIngredient> outputEntries;
    private final IModifierWorktableRecipe recipe;

    public ModifierWorktableDisplay(IModifierWorktableRecipe recipe) {
        ImmutableList.Builder inputs = ImmutableList.builder();
        ImmutableList.Builder outputs = ImmutableList.builder();
        inputs.add((Object)EntryIngredients.ofItemStacks(recipe.getInputTools()));
        int max = Math.min(2, recipe.getInputCount());
        for (int i = 0; i < max; ++i) {
            inputs.add((Object)EntryIngredients.ofItemStacks(recipe.getDisplayItems(i)));
        }
        if (recipe.isModifierOutput()) {
            outputs.add((Object)EntryIngredients.of(TConstructREIConstants.MODIFIER_TYPE, recipe.getModifierOptions(null)));
        } else {
            outputs.add((Object)EntryIngredients.of(TConstructREIConstants.MODIFIER_TYPE, recipe.getModifierOptions(null)));
        }
        this.inputEntries = inputs.build();
        this.outputEntries = outputs.build();
        this.recipe = recipe;
    }

    public CategoryIdentifier<ModifierWorktableDisplay> getCategoryIdentifier() {
        return TConstructREIConstants.MODIFIER_WORKTABLE;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputEntries;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputEntries;
    }

    public IModifierWorktableRecipe getRecipe() {
        return this.recipe;
    }
}

